/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.iceberg.fabric.services;

import com.anthonyhilyard.iceberg.services.IPlatformHelper;
import java.util.List;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.version.VersionPredicate;

public class FabricPlatformHelper
implements IPlatformHelper {
    @Override
    public String getPlatformName() {
        return "Fabric";
    }

    @Override
    public boolean isModLoaded(String modId) {
        return FabricLoader.getInstance().isModLoaded(modId);
    }

    @Override
    public List<String> getAllModIds() {
        return FabricLoader.getInstance().getAllMods().stream().map(mod -> mod.getMetadata().getId()).toList();
    }

    @Override
    public boolean modVersionMeets(String modId, String versionString) {
        if (versionString.contains("<") || versionString.contains(">") || versionString.contains("=") || versionString.contains("~")) {
            return false;
        }
        boolean result = false;
        if (this.isModLoaded(modId)) {
            try {
                result = VersionPredicate.parse((String)(">=" + versionString)).test((Object)((ModContainer)FabricLoader.getInstance().getModContainer(modId).get()).getMetadata().getVersion());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }
}

